/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.ptmp.PacketTracerSession;
import apicore.util.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PacketTracerSessionFactory {
    protected static PacketTracerSessionFactory instance;
    protected List<PacketTracerSession> openSessions;

    protected PacketTracerSessionFactory() {
    }

    public static PacketTracerSessionFactory getInstance() {
        if (instance == null) {
            instance = new PacketTracerSessionFactory();
        }
        return instance;
    }

    public void close() throws IOException {
        if (this.openSessions != null && !this.openSessions.isEmpty()) {
            for (PacketTracerSession packetTracerSession : this.openSessions) {
                packetTracerSession.close();
            }
        }
    }

    public PacketTracerSession openSession(String string, int n, ConnectionNegotiationProperties connectionNegotiationProperties) throws Exception {
        PacketTracerSession packetTracerSession = new PacketTracerSession(string, n, connectionNegotiationProperties);
        if (this.openSessions == null) {
            this.openSessions = new ArrayList<PacketTracerSession>();
        }
        this.openSessions.add(packetTracerSession);
        return packetTracerSession;
    }

    public int openSessionCount() throws IOException {
        int n = 0;
        if (this.openSessions != null) {
            n = this.openSessions.size();
            Logger.info("Number of open sessions: [" + n + "]");
        }
        return n;
    }
}

